<?php
/**
 * Genesis Framework.
 *
 * WARNING: This file is part of the core Genesis Framework. DO NOT edit this file under any circumstances.
 * Please do all modifications in the form of a child theme.
 *
 * @package Genesis\Schema
 * @author  StudioPress
 * @license GPL-2.0-or-later
 * @link    https://my.studiopress.com/themes/genesis/
 */

namespace StudioPress\Genesis\Functions\Schema;

add_filter( 'genesis_attr_head', __NAMESPACE__ . '\\head' );
add_filter( 'genesis_attr_body', __NAMESPACE__ . '\\body' );
add_filter( 'genesis_attr_site-header', __NAMESPACE__ . '\\site_header' );
add_filter( 'genesis_attr_site-title', __NAMESPACE__ . '\\site_title' );
add_filter( 'genesis_attr_site-description', __NAMESPACE__ . '\\site_description' );
add_filter( 'genesis_attr_breadcrumb', __NAMESPACE__ . '\\breadcrumb' );
add_filter( 'genesis_attr_breadcrumb-link-wrap', __NAMESPACE__ . '\\breadcrumb_link_wrap' );
add_filter( 'genesis_attr_breadcrumb-link-wrap-meta', __NAMESPACE__ . '\\breadcrumb_link_wrap_meta' );
add_filter( 'genesis_attr_breadcrumb-link', __NAMESPACE__ . '\\breadcrumb_link', 10, 3 );
add_filter( 'genesis_attr_breadcrumb-link-text-wrap', __NAMESPACE__ . '\\breadcrumb_link_text_wrap' );
add_filter( 'genesis_attr_search-form', __NAMESPACE__ . '\\search_form' );
add_filter( 'genesis_attr_search-form-meta', __NAMESPACE__ . '\\search_form_meta' );
add_filter( 'genesis_attr_search-form-input', __NAMESPACE__ . '\\search_form_input', 10, 3 );
add_filter( 'genesis_attr_nav-primary', __NAMESPACE__ . '\\nav_primary' );
add_filter( 'genesis_attr_nav-secondary', __NAMESPACE__ . '\\nav_secondary' );
add_filter( 'genesis_attr_nav-header', __NAMESPACE__ . '\\nav_header' );
add_filter( 'genesis_attr_nav-link-wrap', __NAMESPACE__ . '\\nav_link_wrap' );
add_filter( 'genesis_attr_nav-link', __NAMESPACE__ . '\\nav_link' );
add_filter( 'genesis_attr_entry', __NAMESPACE__ . '\\entry' );
add_filter( 'genesis_attr_entry-image', __NAMESPACE__ . '\\entry_image' );
add_filter( 'genesis_attr_singular-entry-image', __NAMESPACE__ . '\\singular_entry_image' );
add_filter( 'genesis_attr_entry-image-widget', __NAMESPACE__ . '\\entry_image_widget' );
add_filter( 'genesis_attr_entry-image-grid-loop', __NAMESPACE__ . '\\entry_image_grid_loop' );
add_filter( 'genesis_attr_entry-author', __NAMESPACE__ . '\\entry_author' );
add_filter( 'genesis_attr_entry-author-link', __NAMESPACE__ . '\\entry_author_link' );
add_filter( 'genesis_attr_entry-author-name', __NAMESPACE__ . '\\entry_author_name' );
add_filter( 'genesis_attr_entry-time', __NAMESPACE__ . '\\entry_time' );
add_filter( 'genesis_attr_entry-modified-time', __NAMESPACE__ . '\\entry_modified_time' );
add_filter( 'genesis_attr_entry-title', __NAMESPACE__ . '\\entry_title' );
add_filter( 'genesis_attr_entry-content', __NAMESPACE__ . '\\entry_content' );
add_filter( 'genesis_attr_comment', __NAMESPACE__ . '\\comment' );
add_filter( 'genesis_attr_comment-author', __NAMESPACE__ . '\\comment_author' );
add_filter( 'genesis_attr_comment-author-link', __NAMESPACE__ . '\\comment_author_link' );
add_filter( 'genesis_attr_comment-author-name', __NAMESPACE__ . '\\comment_author_name' );
add_filter( 'genesis_attr_comment-time', __NAMESPACE__ . '\\comment_time' );
add_filter( 'genesis_attr_comment-time-link', __NAMESPACE__ . '\\comment_time_link', 10, 3 );
add_filter( 'genesis_attr_comment-content', __NAMESPACE__ . '\\comment_content' );
add_filter( 'genesis_attr_author-box', __NAMESPACE__ . '\\author_box' );
add_filter( 'genesis_attr_sidebar-primary', __NAMESPACE__ . '\\sidebar_primary' );
add_filter( 'genesis_attr_sidebar-secondary', __NAMESPACE__ . '\\sidebar_secondary' );
add_filter( 'genesis_attr_site-footer', __NAMESPACE__ . '\\site_footer' );

/**
 * Add schema markup attributes for head element.
 *
 * @since 3.1.0
 *
 * @param array $attributes Existing attributes for `head` element.
 * @return array Amended attributes for `head` element.
 */
function head( $attributes ) {
	if ( ! \is_front_page() ) {
		return $attributes;
	}

	$attributes['itemscope'] = true;
	$attributes['itemtype']  = 'https://schema.org/WebSite';

	return $attributes;
}

/**
 * Add schema markup attributes for body element.
 *
 * @since 3.1.0
 *
 * @param array $attributes Existing attributes for `body` element.
 * @return array Amended attributes for `body` element.
 */
function body( $attributes ) {
	$attributes['itemscope'] = true;
	$attributes['itemtype']  = 'https://schema.org/WebPage';

	if ( \is_search() ) {
		$attributes['itemtype'] = 'https://schema.org/SearchResultsPage';
	}

	return $attributes;
}

/**
 * Add schema markup attributes for site header element.
 *
 * @since 3.1.0
 *
 * @param array $attributes Existing attributes for site header element.
 * @return array Amended attributes for site header element.
 */
function site_header( $attributes ) {
	$attributes['itemscope'] = true;
	$attributes['itemtype']  = 'https://schema.org/WPHeader';

	return $attributes;
}

/**
 * Add schema markup attributes for site title element.
 *
 * @since 3.1.0
 *
 * @param array $attributes Existing attributes for site title element.
 * @return array Amended attributes for site title element.
 */
function site_title( $attributes ) {
	$attributes['itemprop'] = 'headline';

	return $attributes;
}

/**
 * Add schema markup attributes for site description element.
 *
 * @since 3.1.0
 *
 * @param array $attributes Existing attributes for site description element.
 * @return array Amended attributes for site description element.
 */
function site_description( $attributes ) {
	$attributes['itemprop'] = 'description';

	return $attributes;
}

/**
 * Add schema markup attributes for breadcrumbs wrapper.
 *
 * @since 3.1.0
 *
 * @param array $attributes Existing attributes for breadcrumbs wrapper element.
 * @return array Amended attributes for breadcrumbs wrapper element.
 */
function breadcrumb( $attributes ) {
	// Homepage breadcrumb content contains no links, so no schema.org attributes are needed.
	if ( is_home() ) {
		return $attributes;
	}

	// Omit attributes if generic breadcrumb functions are in use.
	if ( function_exists( 'breadcrumbs' ) || function_exists( 'crumbs' ) ) {
		return $attributes;
	}

	// Breadcrumb NavXT plugin needs RDFa attributes on the breadcrumb wrapper.
	if ( function_exists( 'bcn_display' ) ) {
		$attributes['typeof'] = 'BreadcrumbList';
		$attributes['vocab']  = 'https://schema.org/';
		return $attributes;
	}

	// Yoast SEO uses JSON-LD and Yoast Breadcrumbs emits no schema.org markup, so no attributes needed.
	$yoast_seo_breadcrumbs_enabled    = class_exists( 'WPSEO_Breadcrumbs' ) && genesis_get_option( 'breadcrumbs-enable', 'wpseo_titles' );
	$yoast_breadcrumbs_plugin_enabled = function_exists( 'yoast_breadcrumb' ) && ! class_exists( 'WPSEO_Breadcrumbs' );

	if ( $yoast_seo_breadcrumbs_enabled || $yoast_breadcrumbs_plugin_enabled ) {
		return $attributes;
	}

	// Genesis breadcrumbs require microdata on the wrapper.
	$attributes['itemprop']  = 'breadcrumb';
	$attributes['itemscope'] = true;
	$attributes['itemtype']  = 'https://schema.org/BreadcrumbList';

	if ( is_singular( 'post' ) || is_archive() || is_home() || is_page_template( 'page_blog.php' ) ) {
		unset( $attributes['itemprop'] );
	}

	return $attributes;
}

/**
 * Add schema markup attributes for breadcrumb item element.
 *
 * @since 3.1.0
 *
 * @param array $attributes Existing attributes for breadcrumb item element.
 * @return array Amended attributes for breadcrumb item element.
 */
function breadcrumb_link_wrap( $attributes ) {
	$attributes['itemprop']  = 'itemListElement';
	$attributes['itemscope'] = true;
	$attributes['itemtype']  = 'https://schema.org/ListItem';

	return $attributes;
}

/**
 * Add schema markup attributes for breadcrumb link wrap meta element.
 *
 * @since 3.1.0
 *
 * @param array $attributes Existing attributes for breadcrumb link wrap meta element.
 * @return array Amended attributes for breadcrumb link wrap meta element.
 */
function breadcrumb_link_wrap_meta( $attributes ) {
	static $position = 0;

	$position++;

	$attributes['itemprop'] = 'position';
	$attributes['content']  = $position;

	return $attributes;
}

/**
 * Add schema markup attributes for breadcrumb link element.
 *
 * @since 3.1.0
 *
 * @param array  $attributes Existing attributes for breadcrumb link element.
 * @param string $context    Not used. Markup context (ie. `footer-widget-area`).
 * @param array  $args       Markup arguments.
 * @return array Amended attributes for breadcrumb link element.
 */
function breadcrumb_link( $attributes, $context, $args ) {
	$attributes['itemprop'] = 'item';

	return $attributes;
}

/**
 * Add schema markup attributes for breadcrumb link text wrap.
 *
 * @since 3.1.0
 *
 * @param array $attributes Existing attributes for breadcrumb link text wrap.
 * @return array Amended attributes for breadcrumb link text wrap.
 */
function breadcrumb_link_text_wrap( $attributes ) {
	$attributes['itemprop'] = 'name';

	return $attributes;
}

/**
 * Add schema markup attributes for search form.
 *
 * @since 3.1.0
 *
 * @param array $attributes Existing attributes for search form element.
 * @return array Amended attributes for search form element.
 */
function search_form( $attributes ) {
	$attributes['itemprop']  = 'potentialAction';
	$attributes['itemscope'] = true;
	$attributes['itemtype']  = 'https://schema.org/SearchAction';

	return $attributes;
}

/**
 * Add schema markup attributes for search form meta tag.
 *
 * @since 3.1.0
 *
 * @param array $attributes Existing attributes for search form meta element.
 * @return array Amended attributes for search form meta element.
 */
function search_form_meta( $attributes ) {
	$attributes['itemprop'] = 'target';

	return $attributes;
}

/**
 * Add schema markup attributes for search form input element.
 *
 * @since 3.1.0
 *
 * @param array  $attributes Existing attributes for footer widget area wrapper elements.
 * @param string $context    Not used. Markup context (ie. `footer-widget-area`).
 * @param array  $args       Markup arguments.
 * @return array Amended attributes.
 */
function search_form_input( $attributes, $context, $args ) {
	$attributes['itemprop'] = 'query-input';

	return $attributes;
}

/**
 * Add schema markup attributes for primary navigation element.
 *
 * @since 3.1.0
 *
 * @param array $attributes Existing attributes for primary navigation element.
 * @return array Amended attributes for navigation elements.
 */
function nav_primary( $attributes ) {
	$attributes['itemscope'] = true;
	$attributes['itemtype']  = 'https://schema.org/SiteNavigationElement';

	return $attributes;
}

/**
 * Add schema markup attributes for secondary navigation element.
 *
 * @since 3.1.0
 *
 * @param array $attributes Existing attributes for secondary navigation element.
 * @return array Amended attributes for navigation elements.
 */
function nav_secondary( $attributes ) {
	$attributes['itemscope'] = true;
	$attributes['itemtype']  = 'https://schema.org/SiteNavigationElement';

	return $attributes;
}

/**
 * Add schema markup attributes for header navigation element.
 *
 * @since 3.1.0
 *
 * @param array $attributes Existing attributes for header navigation element.
 * @return array Amended attributes for navigation elements.
 */
function nav_header( $attributes ) {
	$attributes['itemscope'] = true;
	$attributes['itemtype']  = 'https://schema.org/SiteNavigationElement';

	return $attributes;
}
/**
 * Add schema markup attributes for the span wrap around navigation item links.
 *
 * @since 3.1.0
 *
 * @param array $attributes Existing attributes for span wrap around navigation item links.
 * @return array Amended attributes for span wrap around navigation item links.
 */
function nav_link_wrap( $attributes ) {
	$attributes['itemprop'] = 'name';

	return $attributes;
}

/**
 * Add schema markup attributes for the navigation item links.
 *
 * @since 3.1.0
 *
 * @param array $attributes Existing attributes for navigation item links.
 * @return array Amended attributes for navigation item links.
 */
function nav_link( $attributes ) {
	$attributes['itemprop'] = 'url';

	return $attributes;
}

/**
 * Add schema markup attributes for entry element.
 *
 * @since 3.1.0
 *
 * @param array $attributes Existing attributes for entry element.
 * @return array Amended attributes for entry element.
 */
function entry( $attributes ) {
	if ( ! \is_main_query() && ! \genesis_is_blog_template() ) {
		return $attributes;
	}

	$attributes['itemscope'] = true;
	$attributes['itemtype']  = 'https://schema.org/CreativeWork';

	return $attributes;
}

/**
 * Add schema markup attributes for entry image element.
 *
 * @since 3.1.0
 *
 * @param array $attributes Existing attributes for entry image element.
 * @return array Amended attributes for entry image element.
 */
function entry_image( $attributes ) {
	$attributes['itemprop'] = 'image';

	return $attributes;
}

/**
 * Add attributes for singular entry image element.
 *
 * @since 3.1.0
 *
 * @param array $attributes Existing attributes for entry image element.
 * @return array Amended attributes for entry image element.
 */
function singular_entry_image( $attributes ) {
	$attributes['itemprop'] = 'image';

	return $attributes;
}

/**
 * Add schema markup attributes for entry image element shown in a widget.
 *
 * @since 3.1.0
 *
 * @param array $attributes Existing attributes for entry image element shown in a widget.
 * @return array Amended attributes for entry image element shown in a widget.
 */
function entry_image_widget( $attributes ) {
	$attributes['itemprop'] = 'image';

	return $attributes;
}

/**
 * Add schema markup attributes for entry image element shown in a grid loop.
 *
 * @since 3.1.0
 *
 * @param array $attributes Existing attributes for entry image element shown in a grid loop.
 * @return array Amended attributes for entry image element shown in a grid loop.
 */
function entry_image_grid_loop( $attributes ) {
	$attributes['itemprop'] = 'image';

	return $attributes;
}

/**
 * Add schema markup attributes for author element for an entry.
 *
 * @since 3.1.0
 *
 * @param array $attributes Existing attributes for author element for an entry.
 * @return array Amended attributes for author element for an entry.
 */
function entry_author( $attributes ) {
	$attributes['itemprop']  = 'author';
	$attributes['itemscope'] = true;
	$attributes['itemtype']  = 'https://schema.org/Person';

	return $attributes;
}

/**
 * Add schema markup attributes for entry author link element.
 *
 * @since 3.1.0
 *
 * @param array $attributes Existing attributes for entry author link element.
 * @return array Amended attributes for entry author link element.
 */
function entry_author_link( $attributes ) {
	$attributes['itemprop'] = 'url';

	return $attributes;
}

/**
 * Add schema markup attributes for entry author name element.
 *
 * @since 3.1.0
 *
 * @param array $attributes Existing attributes for entry author name element.
 * @return array Amended attributes for entry author name element.
 */
function entry_author_name( $attributes ) {
	$attributes['itemprop'] = 'name';

	return $attributes;
}

/**
 * Add schema markup attributes for time element for an entry.
 *
 * @since 3.1.0
 *
 * @param array $attributes Existing attributes for time element for an entry.
 * @return array Amended attributes for time element for an entry.
 */
function entry_time( $attributes ) {
	$attributes['itemprop'] = 'datePublished';
	$attributes['datetime'] = get_the_time( 'c' );

	return $attributes;
}

/**
 * Add schema markup attributes for modified time element for an entry.
 *
 * @since 3.1.0
 *
 * @param array $attributes Existing attributes for modified time element for an entry.
 * @return array Amended attributes for modified time element for an entry.
 */
function entry_modified_time( $attributes ) {
	$attributes['itemprop'] = 'dateModified';
	$attributes['datetime'] = get_the_modified_time( 'c' );

	return $attributes;
}

/**
 * Add schema markup attributes for entry title element.
 *
 * @since 3.1.0
 *
 * @param array $attributes Existing attributes for entry title element.
 * @return array Amended attributes for entry title element.
 */
function entry_title( $attributes ) {
	$attributes['itemprop'] = 'headline';

	return $attributes;
}

/**
 * Add schema markup attributes for entry content element.
 *
 * @since 3.1.0
 *
 * @param array $attributes Existing attributes for entry content element.
 * @return array Amended attributes for entry content element.
 */
function entry_content( $attributes ) {
	if ( ! \is_main_query() && ! \genesis_is_blog_template() ) {
		return $attributes;
	}

	$attributes['itemprop'] = 'text';

	return $attributes;
}

/**
 * Add schema markup attributes for single comment element.
 *
 * @since 3.1.0
 *
 * @param array $attributes Existing attributes for single comment element.
 * @return array Amended attributes for single comment element.
 */
function comment( $attributes ) {
	$attributes['itemprop']  = 'comment';
	$attributes['itemscope'] = true;
	$attributes['itemtype']  = 'https://schema.org/Comment';

	return $attributes;
}

/**
 * Add schema markup attributes for comment author element.
 *
 * @since 3.1.0
 *
 * @param array $attributes Existing attributes for comment author element.
 * @return array Amended attributes for comment author element.
 */
function comment_author( $attributes ) {
	$attributes['itemprop']  = 'author';
	$attributes['itemscope'] = true;
	$attributes['itemtype']  = 'https://schema.org/Person';

	return $attributes;
}

/**
 * Add schema markup attributes for comment author link element.
 *
 * @since 3.1.0
 *
 * @param array $attributes Existing attributes for comment author link element.
 * @return array Amended attributes for comment author link element.
 */
function comment_author_link( $attributes ) {
	$attributes['itemprop'] = 'url';

	return $attributes;
}

/**
 * Add schema markup attributes for comment author name element.
 *
 * @since 3.1.0
 *
 * @param array $attributes Existing attributes for comment author name element.
 * @return array Amended attributes for comment author name element.
 */
function comment_author_name( $attributes ) {
	$attributes['itemprop'] = 'name';

	return $attributes;
}

/**
 * Add schema markup attributes for comment time element.
 *
 * @since 3.1.0
 *
 * @param array $attributes Existing attributes for comment time element.
 * @return array Amended attributes for comment time element.
 */
function comment_time( $attributes ) {
	$attributes['datetime'] = \get_comment_time( 'c' );
	$attributes['itemprop'] = 'datePublished';

	return $attributes;
}

/**
 * Add schema markup attributes for comment time link element.
 *
 * @since 3.1.0
 *
 * @param array $attributes Existing attributes for comment time link element.
 * @param array $context Not used. Markup context (ie. `footer-widget-area`).
 * @param array $args Arguments.
 * @return array Amended attributes for comment time link.
 */
function comment_time_link( $attributes, $context, $args ) {
	$attributes['itemprop'] = 'url';

	return $attributes;
}

/**
 * Add schema markup attributes for comment content container.
 *
 * @since 3.1.0
 *
 * @param array $attributes Existing attributes for comment content container.
 * @return array Amended attributes for comment content container.
 */
function comment_content( $attributes ) {
	$attributes['itemprop'] = 'text';

	return $attributes;
}


/**
 * Add schema markup attributes for author box element.
 *
 * @since 3.1.0
 *
 * @param array $attributes Existing attributes for author box element.
 * @return array Amended attributes for author box element.
 */
function author_box( $attributes ) {
	$attributes['itemprop']  = 'author';
	$attributes['itemscope'] = true;
	$attributes['itemtype']  = 'https://schema.org/Person';

	return $attributes;
}

/**
 * Add schema markup attributes for primary sidebar element.
 *
 * @since 3.1.0
 *
 * @param array $attributes Existing attributes for primary sidebar element.
 * @return array Amended attributes for primary sidebar element.
 */
function sidebar_primary( $attributes ) {
	$attributes['itemscope'] = true;
	$attributes['itemtype']  = 'https://schema.org/WPSideBar';

	return $attributes;
}

/**
 * Add schema markup attributes for secondary sidebar element.
 *
 * @since 3.1.0
 *
 * @param array $attributes Existing attributes for secondary sidebar element.
 * @return array Amended attributes for secondary sidebar element.
 */
function sidebar_secondary( $attributes ) {
	$attributes['itemscope'] = true;
	$attributes['itemtype']  = 'https://schema.org/WPSideBar';

	return $attributes;
}

/**
 * Add schema markup attributes for site footer element.
 *
 * @since 3.1.0
 *
 * @param array $attributes Existing attributes for site footer element.
 * @return array Amended attributes for site footer element.
 */
function site_footer( $attributes ) {
	$attributes['itemscope'] = true;
	$attributes['itemtype']  = 'https://schema.org/WPFooter';

	return $attributes;
}
